//
// (C) Copyright 1993-1999 by Autodesk, Inc.
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted,
// provided that the above copyright notice appears in all copies and
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC.
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// DESCRIPTION:
//
//  Sample MAP ARX API application. (Thorough error checking is ommited.)
//


#include "stdafx.h"           // MFC stuff

#include <acdb.h>             // acdb definitions
#include <adslib.h>           // ads defs
#include "aced.h"             // aced stuff
#include <dbmain.h>
#include <dbsymtb.h>
#include <dbents.h>
#include <dbgroup.h>
#include <accmd.h>
#include <adscodes.h>
#include <rxregsvc.h>

#include <MapArxApi.h>
#include <MapSession.h>
#include <MapProj.h>
#include <MapReactors.h>
#include <MapBoundary.h>
#include <MapQuery.h>
#include <MapAlteration.h>
#include <MapValue.h>
#include <MapTemplate.h>
#include <gemat3d.h>
#include <MapStringArray.h>

// message handlers
static void OnkLoadDwgMsg  (void);
static void OnkUnloadDwgMsg(void);
static void OnkEndMsg      (void);
static void OnkQuitMsg     (void);

// helper functions
static void initApp  (void);
static void unloadApp(void);

// samples
void propAlt();
void DefineRangeLines();
void TextAlt();
void HatchAlt();

/////////////////////////////////////////////////////////////////////
// acrxEntryPoint(internal)
// This function is the entry point for your application.
/////////////////////////////////////////////////////////////////////
extern "C" AcRx::AppRetCode acrxEntryPoint(AcRx::AppMsgCode msg, void* ptr)
{
  switch (msg) {
    case AcRx::kInitAppMsg:
	  acrxRegisterAppMDIAware(ptr);
      acrxUnlockApplication(ptr);
      initApp();
      break;
    case AcRx::kUnloadAppMsg:
      unloadApp();
      break;
    case AcRx::kLoadDwgMsg:
      OnkLoadDwgMsg();
      break;
    case AcRx::kUnloadDwgMsg:
      OnkUnloadDwgMsg();
      break;
    case AcRx::kEndMsg:
      OnkEndMsg();
      break;
    case AcRx::kQuitMsg:
      OnkQuitMsg();
      break;
    default:
      break;
  }
  return AcRx::kRetOK;
}


static void OnkLoadDwgMsg(void)
{
  // TODO: add your message handler code here

  // end of message handler
}
static void OnkUnloadDwgMsg(void)
{
	
}
static void OnkEndMsg(void)
{
  // TODO: add your message handler code here

  // end of message handler
}
static void OnkQuitMsg(void)
{
  // TODO: add your message handler code here

  // end of message handler
}

static void initApp(void)
{
   // register your autocad commands
  acedRegCmds->addCommand("PropAlt", "PropAlt", "PropAlt", ACRX_CMD_TRANSPARENT, propAlt);
  
} // END initApp()

static void unloadApp(void)
{
	// unregister your autocad commands
	acedRegCmds->removeGroup("PropAlt");
}

//////////////////////////////////////
// MAIN LOOP - propAlt()
//
// Clears the current query and calls
// DefineRangeLines(), TextAlt() and 
// HatchAlt().
//////////////////////////////////////
void propAlt()
{
	AcMapSession *mapSession = NULL;
	mapSession = AcMapGetSession();
	if(mapSession) 
	{
		AcMapProject *pProj;
		if(mapSession->GetProject(pProj) == Adesk::kTrue)
		{
			//Get the current Query
			AcMapQuery *pCurrentQuery = NULL;
			if(pProj->CreateQuery(pCurrentQuery, Adesk::kTrue) == AcMap::kOk)
			{
				//Before we start, clear the current query
				pCurrentQuery->Clear(Adesk::kTrue);
			}

			//clean up
			if(pCurrentQuery)
				delete pCurrentQuery;
		}
	}
	
	DefineRangeLines();
	TextAlt();
	HatchAlt();
}

//////////////////////////////////
// DefineRangeLines()
//
// Creates two range tables and
// adds then to the range library
//////////////////////////////////
void DefineRangeLines()
{	
	AcMapSession *mapSession = NULL;

	try
	{
		mapSession = AcMapGetSession();
		if(mapSession) 
		{
			AcMapProject *pProj;
			if(mapSession->GetProject(pProj) == Adesk::kTrue)
			{
				//Get the range library
				AcMapRangeLibrary *pRangeLib = NULL;
				if (pProj->GetRangeLibrary(pRangeLib) == Adesk::kTrue)
				{
					//Add a range table to the library
					AcMapRangeTable *pTable = NULL;
					const char *pcName = "MyTypeRangeTable";
					const char *pcDsc = "Table for types";
					if(pRangeLib->AddRangeTable(pTable, pcName, pcDsc) == AcMap::kOk)
					{
						// Add range lines that will add text next to the entites
						// that match the input criteria.
						pTable->AddRangeLine(AcMap::kRangeEq, "circle", "CIRCLE");
						pTable->AddRangeLine(AcMap::kRangeEq, "polygon", "POLYGON");
						pTable->AddRangeLine(AcMap::kRangeEq, "polyline", "PLINE");
						pTable->AddRangeLine(AcMap::kRangeEq, "line", "LINE");
						pTable->AddRangeLine(AcMap::kRangeEq, "lwpolyline", "LWPOLYLINE");
						pTable->AddRangeLine(AcMap::kRangeEq, "text", "TEXT");
						pTable->AddRangeLine(AcMap::kRangeOtherwise, NULL, "Unknown Type");
					}
											
					//clean up
					if(pTable)
					{
						delete pTable;
						pTable = NULL;
					}

					pcName = "MyHatchRangeTable";
					pcDsc = "Table for hatch ranges";
					if(pRangeLib->AddRangeTable(pTable, pcName, pcDsc) == AcMap::kOk)
					{
						// Add range lines that will add hatch patterns to the entites
						// that match the input criteria.
						pTable->AddRangeLine(AcMap::kRangeEq, "circle", "ANSI31");
						pTable->AddRangeLine(AcMap::kRangeEq, "polygon", "CROSS");
						pTable->AddRangeLine(AcMap::kRangeEq, "polyline", "ANSI33");
						pTable->AddRangeLine(AcMap::kRangeEq, "lwpolyline", "DASH");
						pTable->AddRangeLine(AcMap::kRangeOtherwise, NULL, "SOLID");
					}
											
					//clean up
					if(pTable)
					{
						delete pTable;
						pTable = NULL;
					}
				}
			}
		}
	}
	catch(...)
	{
		//do some error handling
	}
}

/////////////////////////////////////////////
// TextAlt()
//
// Creates a Text Alteration and sets the
// expression to the table, MyTypeRangeTable.
//
/////////////////////////////////////////////
void TextAlt()
{
	AcMapSession *mapSession = NULL;

	try
	{
		mapSession = AcMapGetSession();
		if(mapSession) 
		{
			AcMapProject *pProj;
			if(mapSession->GetProject(pProj) == Adesk::kTrue)
			{
				//Get the current Query
				AcMapQuery *pCurrentQuery = NULL;
				if(pProj->CreateQuery(pCurrentQuery, Adesk::kTrue) == AcMap::kOk)
				{
					//clear the current query
					//pCurrentQuery->Clear(Adesk::kTrue);
										
					//Get the Property alteration object from the query
					AcMapPropertyAlterationDefinition *pPADef = NULL;
					if(pCurrentQuery->GetPropertyAlteration(pPADef) == AcMap::kOk)
					{
						AcMapPropertyAlteration *pPropAltObj = NULL;

						//Add a Text Alteration
						if(pPADef->AddAlteration(pPropAltObj, AcMap::kAlterationTextEntity) == AcMap::kOk)
						{
							//First we need to cast it
							AcMapTextAlteration *pTextAlt = NULL;
							pTextAlt = (AcMapTextAlteration*)pPropAltObj;

							//set some attributes
							pTextAlt->SetColor("Magenta");
							pTextAlt->SetJustification("MIDDLE");
							pTextAlt->SetRotation("45.0");
							pTextAlt->SetHeight("0.5");
							pTextAlt->SetExpression("(Range .TYPE MyTypeRangeTable)");
						}

						//clean up
						if(pPropAltObj)
						{
							delete pPropAltObj;
							pPropAltObj = NULL;
						}
					}

					//enable property alterations for the query
					pCurrentQuery->EnablePropertyAlteration(Adesk::kTrue);
					
					// Create a query branch Entity Type = ALL
					AcMapQueryBranch qBranch;
					AcMapPropertyCondition propCond;

					propCond.SetPropertyType(AcMap::kEntType);
					propCond.SetConditionOperator(AcMap::kCondEq);
					propCond.SetValue("*") ;
					
					qBranch.AppendOperand(&propCond);

					// define the query branch
					pCurrentQuery->Define(&qBranch);
					
					//set the query mode to draw
					pCurrentQuery->SetMode(AcMap::kQueryDraw);
					
					// run the query
					pCurrentQuery->Run();
				}

				//clean up
				if(pCurrentQuery)
					delete pCurrentQuery;
			}
		}
	}
	catch(...)
	{
		//do some error handling
	}
}

/////////////////////////////////////////////
// HatchAlt()
//
// Creates a Hatch Alteration and sets the
// expression to the table, MyHatchRangeTable.
//
/////////////////////////////////////////////
void HatchAlt()
{
	AcMapSession *mapSession = NULL;

	try
	{
		mapSession = AcMapGetSession();
		if(mapSession) 
		{
			AcMapProject *pProj;
			if(mapSession->GetProject(pProj) == Adesk::kTrue)
			{
				//Get the current Query
				AcMapQuery *pCurrentQuery = NULL;
				if(pProj->CreateQuery(pCurrentQuery, Adesk::kTrue) == AcMap::kOk)
				{
					//Get the Property alteration object from the query
					AcMapPropertyAlterationDefinition *pPADef = NULL;
					if(pCurrentQuery->GetPropertyAlteration(pPADef) == AcMap::kOk)
					{
						AcMapPropertyAlteration *pPropAltObj = NULL;

						//Now add a Hatch Alteration
						if(pPADef->AddAlteration(pPropAltObj, AcMap::kAlterationHatch) == AcMap::kOk)
						{
							//First we need to cast it
							AcMapHatchAlteration *pHatchAlt = NULL;
							pHatchAlt = (AcMapHatchAlteration*)pPropAltObj;

							//set some attributes
							pHatchAlt->SetScale("2.0");
							pHatchAlt->SetColor("Yellow");
							pHatchAlt->SetRotation("45.0");
							pHatchAlt->SetExpression("(Range .TYPE MyHatchRangeTable)");
						}

						//clean up
						if(pPropAltObj)
						{
							delete pPropAltObj;
							pPropAltObj = NULL;
						}
					}

					//enable property alterations for the query
					pCurrentQuery->EnablePropertyAlteration(Adesk::kTrue);
					
					// Create a query branch Entity Type = ALL
					AcMapQueryBranch qBranch;
					AcMapPropertyCondition propCond;

					propCond.SetPropertyType(AcMap::kEntType);
					propCond.SetConditionOperator(AcMap::kCondEq);
					propCond.SetValue("*") ;
					
					qBranch.AppendOperand(&propCond);

					// define the query branch
					pCurrentQuery->Define(&qBranch);
					
					//set the query mode to draw
					pCurrentQuery->SetMode(AcMap::kQueryDraw);
					
					// run the query
					pCurrentQuery->Run();
				}
				
				//clean up
				if(pCurrentQuery)
					delete pCurrentQuery;
			}
		}
	}
	catch(...)
	{
		//do some error handling
	}
}
	


// END
